//=============================================================================
// Shop Button, for when no one's watching the shop!
//=============================================================================
class ShopButtonC extends DeusExDecoration;

var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

//=============================================
//new stuff------------------------------------
//=============================================
var() bool bModLooks; //are we buying clothes?
var() texture NewClothes[8]; //our new multiskins...
var() mesh NewMesh; //our new mesh, if we're buying clothes.
//var() localized string ShopMessage; //obsolete
var() class<actor> BoughtItem; //what are we buying?
//--------------------------------
//obsolete as of 1_2
//--------------------------------
//var() vector PlacementLocation, RegisterLocation; //where to put the item and cash
//--------------------------------
//now we use this
//--------------------------------
var() localized string PlacementLocString; //string going to be used by the placement locator, saves a LOT of time...
var() localized string RegisterLocString; //Same thing for vault loc.
var() int ItemPrice; //how much does this cost?
var() localized string BoughtItemName; //what's the fancy name for this?
var() int NumToGive; //for more customization and for wafo bar 2 for 25$ specials!
var() string ShopString; //used by job buttons

//late additions to this actor
var() string AlternativeClassName; //the string equivelant of the class's name
var() bool bUseString; //do we use the string or the actor input?
var() bool bSabotaged;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
        /*reliable if ( Role < ROLE_Authority )
                ItemPrice, bInModMode;*/
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	isPressed = False;
}

function Frob(Actor Frobber, Inventory frobWith)
{
local Actor A;
local Pawn P;
local Credits C;
local int j;
local VaultLocPoint VaultLoc;
local PlacementLocPoint PlacementLoc;
local vector PlacementLocation, RegisterLocation;
local class<actor> aClass;

  P = Pawn(Frobber);

if (bUseString)
 aClass = class<Actor>(DynamicLoadObject(AlternativeClassName, class'Class'));
if (!bUseString)
 aClass = BoughtItem;

if ((aClass != None) && (!bSabotaged))
{
forEach AllActors(class'VaultLocPoint', VaultLoc)
{
forEach AllActors(class'PlacementLocPoint', PlacementLoc)
{
 if ((VaultLoc != None) && (VaultLoc.AreaString ~= RegisterLocString))
 {
  RegisterLocation = VaultLoc.Location;
 }
 if ((PlacementLoc != None) && (PlacementLoc.AreaString ~= PlacementLocString))
 {
  PlacementLocation = PlacementLoc.Location;
 }
}
}
    if ((DeusExPlayer(Frobber) != None) && (DeusExPlayer(Frobber).Credits >= ItemPrice))
    {
     Super.Frob(Frobber, frobWith);

     if (bModLooks)
     {
     P.MultiSkins[0] = NewClothes[0];
     P.MultiSkins[1] = NewClothes[1];
     P.MultiSkins[2] = NewClothes[2];
     P.MultiSkins[3] = NewClothes[3];
     P.MultiSkins[4] = NewClothes[4];
     P.MultiSkins[5] = NewClothes[5];
     P.MultiSkins[6] = NewClothes[6];
     P.MultiSkins[7] = NewClothes[7];
     P.Mesh = NewMesh;
     }
    for (j=0; j<NumToGive; j++)
     {
      A = Spawn(aClass, Frobber,, PlacementLocation);
      //A.bOnlyOwnerSee = True; //doesnt work on weps and fucks up the rest...
      if (A.IsA('Inventory'))
      {
      Inventory(A).RespawnTime = 0.000000;
      if (A.IsA('Weapon')) Weapon(A).bWeaponStay = False;
      //A.Frob(Frobber,FrobWith);
      }
      if (A.IsA('DeusExDecoration')) 
      { 
      DeusExDecoration(A).bPushable = True; //make sure we can move our stuff!
       if (DeusExDecoration(A).Mass > 20) DeusExDecoration(A).Mass = 20;
      }
     }
     DeusExPlayer(Frobber).Credits -= ItemPrice;
    if (ItemPrice > 0)
    {
     DeusExPlayer(Frobber).ClientMessage("|p3You have succesfully boughten a "$BoughtItemName$", "$ItemPrice$" dollars deducted from your wallet.");
     C = Spawn(class'DeusEx.Credits',,, RegisterLocation);
     C.numCredits = ItemPrice;
     return; //finish our stuff first
     }
     else if (ItemPrice <= 0)
     {
      DeusExPlayer(Frobber).ClientMessage("|p3You have just recieved a free "$BoughtItemName$"!");
      return;
     }
     else
       return; //make sure we don't spam away at frobs
    }
    else if (DeusExPlayer(Frobber).Credits < ItemPrice)
    {
     DeusExPlayer(Frobber).ClientMessage("|p2You don't have the required "$ItemPrice$" Dollars required to buy a "$BoughtItemName$"!");
     return;
    }

}
else if (AClass == None)
{
 if (!bSabotaged)
 {
  DeusExPlayer(Frobber).ClientMessage("|p2This item appears to have not been set due to a mapping error! Please report this as a bug!");
  return;
 }
}

if (bSabotaged)
{
 DeusExPlayer(Frobber).ClientMessage("|cf88This product appears to be sabotaged! Perhaps you could help...");
 return;
}
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep1'
     bInvincible=True
     bCollideActors=True
     bBlockActors=True
     bProjTarget=True
     ItemName="|p3Shop Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
     NumToGive=1
}
